/************************************************************************************
* This file contains Platform specific implentations of BTA functions.
* For the Windows Simulator Platform.
*
* Author(s): Thomas O. Jensen
*
* (c) Copyright 2004, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
************************************************************************************
*	 10/13/06	HS 	The mSETUP_PORT_TIMER micro replaced with mSETUP_PORT_DATAH
*					Header file renamed for HPRFGW
*					The NV_Data.h and PowerManager.h file commented-out
************************************************************************************/


/************************************************************************************
* Includes
************************************************************************************/
#include "hprfgw_config.h"
#if defined (OS_NUCLEUS)
 #include <nucleus.h>
 #include "system.h"
#elif defined (OS_WINCE)
 #include <windows.h>
 #include <ceddk.h>
 #include <bsp.h>
 #include "hprf_winceIntfc.h"
#endif
#include "hprfgw_rfSlaveIntToRfApp.h"
#include "hprfgw_rfPortConfig.h"
#include "hprfgw_rfIrqControlLib.h"
#include "hprfgw_rfPlatformInit.h"
#include "hprfgw_rfSlaveIntToHost.h"
#include "hprfgw_rfSlaveIntToRfApp.h"


/*************************************************************************************
*************************************************************************************
* External platform references
*************************************************************************************
************************************************************************************/
extern void DisableInterrupt(BOOL hi, UINT32 mask);
extern void EnableInterrupt(BOOL hi, UINT32 mask);

#if defined (OS_NUCLEUS)
 //	MC13192 PHY interrupt level and vector
 #define RFRECEIVE_MC13192PHY_INTLEV		       (MCF_INTC0_ICRn_IL(6)|MCF_INTC0_ICRn_IP(7))  // fixed because it's an Ext Interrupt
#endif


/*************************************************************************************
*************************************************************************************
* Private functions
*************************************************************************************
************************************************************************************/
#if defined (OS_NUCLEUS)
//	RF receiver timer LISR/HISR parameters 
#define PIT3_TIMER_VECT					    103			//	PIT3 timer vector  
#define PIT3_TIMER_INTLEV           		(MCF_INTC0_ICRn_IL(3)|MCF_INTC0_ICRn_IP(0))  
#define RFREC_TIMER_HISR_PRIORITY       	1			//	timer hisr priority (0=highest priority, 2=lowest priority)
#define RFREC_TIMER_HISR_STACK_SIZE			8000		//	timer hisr stack size

#define RFREC_TIMER_RATE_USEC				1500		// Receiver timer rate in micro seconds

typedef struct	{
    NU_HISR 	timerhisr;
    UINT8		timerhisrstack[RFREC_TIMER_HISR_STACK_SIZE];
}	RFRECTASKHISR;
RFRECTASKHISR RFRecTaskHisr;
#elif defined (OS_WINCE)

// NOTE: Should be greater than or equal to 1000
#define RFREC_TIMER_RATE_USEC				10000 //20000 //1500		/* 1500 micro seconds */

typedef struct	{
    HANDLE    hIntrThread;
    HANDLE    hIntrEvent;
    DWORD     dwSysIntr;

}	RFRECTASKHISR;
RFRECTASKHISR RFRecTaskHisr = {0, 0, 0};

//Static variables
//Pointer to timer register

//Static functions
static DWORD RFReceiveTimer_IntrThread(VOID *pContext);

#endif

/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function initializes the RF receive timer but keep it disabled
 *
 * \detail		
 * \date        08/23/2006
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
void RFReceive_TimerInitialize (void)
{
    // allocate the interrupt event for timer
    RFRecTaskHisr.hIntrEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

    if (NULL == RFRecTaskHisr.hIntrEvent)
    {
        RFIntHostApp.pF_ErrorPrintf("RFReceive_TimerInitialize: Failed create Rx Timer3 event");
        goto cleanUp;
    }
    
    // Start interrupt service thread
    RFRecTaskHisr.hIntrThread = CreateThread(NULL, 0, RFReceiveTimer_IntrThread, pHPRDevice, 0,NULL);
    if (!RFRecTaskHisr.hIntrThread)
    {
        RFIntHostApp.pF_ErrorPrintf("RFReceive_TimerInitialize: Failed create interrupt thread");
        goto cleanUp;
    }
    // Set thread priority
    CeSetThreadPriority(RFRecTaskHisr.hIntrThread, RF_INTR_THREAD_PRIORITY);

cleanUp:
    return;

}  


/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function is called by the RF receiver timer LISR interrupt.
 *
 * \detail		This function calls the mlm_Main() which is basically process the data/command
 *				messages which are pending in any of the MAC input queues. The function returns 
 *				TRUE it it has more messages to process then it should be called again immediatly.
 *				OthereiseFA
 *				queue/dequeuframes
 * 
 * \date        08/22/2006
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
void RFReceive_Timer_HISR(void)
{
#if defined (OS_NUCLEUS)
    cpu->PODR.TIMER |= PDDR_TIMER_DDTIMER5; 
    RFReceive_Timer_HISR_Function();
    cpu->PODR.TIMER &= ~PDDR_TIMER_DDTIMER5; 
#endif
}



/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function is called on RF receiver timer interrupt. It activtes the RF receive timer HISR
 *
 * \detail		
 * 
 * \date        08/22/2006
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
#if defined (OS_NUCLEUS)
void RFReceive_Timer_LISR(int vector_num)
{

    //	Aknowledge the pit timer	
    cpu->pi_timer[3].PCSR |= PCSRn_PIF;

    //	Start the RF receiver timer processing routine which calls the RF stack 
    NU_Activate_HISR (&RFRecTaskHisr.timerhisr);
}
#endif

/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function disables the RF receiver timer interrupt	 			           
 *
 * \detail		
 * \date        08/23/2006
 *
 * \param	    None
 *
 * \return		UINT16 result 			
 *
 * \retval		SUCCESS/FAILURE 
 */
UINT16 RFReceive_DisableTimerInterrupt (void)	{
    UINT16 	result = SUCCESS;

#ifdef FREESCALE_802_15_4_STACK
#if defined (OS_NUCLEUS)
    PIT_5271_Regs* timer = mcf5271_pit3_ptr();
    int old_level;
    
    old_level = NU_Local_Control_Interrupts(NET_EthernetInterruptLevel);	
    //timer->ctrl_status_reg  &= ~(MCF_PIT_PCSR_PIE);
    DisableInterrupt(TRUE,  MCF_IMRH_PIT3_INT);
    NU_Local_Control_Interrupts(old_level);
#elif defined (OS_WINCE)
    #error "Not configured for Win CE"
#endif
#endif //#ifdef FREESCALE_802_15_4_STACK

    return (result);
}  

/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function enables the RF receiver timer interrupt	 			           
 *
 * \detail		
 * \date        08/23/2006
 * \param	    None
 *
 * \return		UINT16 result 			
 *
 * \retval		SUCCESS/FAILURE 
 */
UINT16 RFReceive_EnableTimerInterrupt (void)
{
    UINT16 	result = SUCCESS;

    return (result);
}  


UINT16	RFReceive_GetTimerValue (void)
{
    return ((UINT16)GetTickCount());
}



/**
 * \author         original
 * \brief          This function acts as the IST for the Motion.
 * \detail         As interrupts are triggered, windows messages are sent to notify
 *                 applications
 * \date           04/30/03 2:55:PM
 *  \param         context - pointer to MotionDevice_t structure
 *  \return        dword indicating success or failure
 *  \retval        non zero value indicates success
 */
DWORD RFReceiveTimer_IntrThread(VOID *pContext)
{
    DWORD dwResult = 0;

    static DWORD dwToggle = 0;
    
    RFIntHostApp.pF_ErrorPrintf("\r\nRFReceiveTimer_IntrThread: Running!");

    // Loop until we are stopped...
    while (1)
    {
        // Wait for the interrupt to happen
        dwResult = WaitForSingleObject(RFRecTaskHisr.hIntrEvent, RFREC_TIMER_RATE_USEC/1000);

        if (dwResult == WAIT_TIMEOUT)
        {
            // Call the RFReceive timer hisr function
            RFReceive_Timer_HISR_Function();
        }
        else
        {
            RFIntHostApp.pF_ErrorPrintf("RFRxTmrIntr: Err wait: %d", dwResult);
        }
    }

    if(RFRecTaskHisr.hIntrEvent)
        CloseHandle(RFRecTaskHisr.hIntrEvent);

    return ERROR_SUCCESS;
}

/**
 * \author         original
 * \brief          Disable the timer at power down.
 * \date           03/22/2011
 *  \return        none
 */
void RFReceive_TimerPowerDown(void)
{
    // Not using any timer
}

/**
 * \author         original
 * \brief          Enable the timer at power up.
 * \date           03/22/2011
 *  \return        none
 */
void RFReceive_TimerPowerUp(void)
{
    // Not using any timer
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////// Define checks///////////////////////////////
///////////////////////////////////////////////////////////////////////////

#if defined (FREESCALE_802_15_4_STACK)
    #error "Windows CE dependecies with this needs to be worked out"
#endif

#if (RFREC_TIMER_RATE_USEC < 1000)
    #error "RFREC_TIMER_RATE_USEC should be greater than or equal to 1000"
#endif


///////////////////////////////////////////////////////////////////////////